#!/bin/bash
# Copyright (c) 2022 Symas Corporation
# All rights reserved.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
# 
# * Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
# * Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in
# the documentation and/or other materials provided with the
# distribution.
# * Neither the name of the Symas Corporation nor the names of its
# contributors may be used to endorse or promote products derived
# from this software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# bt.sh
# -----
# Make a tarball to install Symas OpenLDAP that was built by the bs,sh
# script.
# 
# ***** WARNING *****
# This script deletes the contents of the directory pointed to by
# $syPrefix and fills it with the contents of the rpms listed
# below.
#
#set -x

# Pick up common variables and functions
source ./common.sh

# Check the environment to make sure it's sane
checkenv || echo "ERROR: Environment is not sane ..." || exit 1

# Clean up the temprary working directory (usually a noop)
rm -rf $syWork || exit 2

#
# Loop, "installing" each binary RPM using rpm2cpio, The product of this
# loop is a populated set of directories and subdirectories that will
# be used to produce the installation tarball.
# Our input is simply a list of RPM files that were produced by the bs.sh
# script.
mkdir -p $syWork || echo "ERROR: " || exit 3
while read rpmName; do
	# "Install" the RPMS that were built by bs.sh
	echo Copy files from rpm $rpmName to $syWork
	rpm2cpio $buildDir/RPMS/x86_64/$rpmName | cpio -iud -D $syWork # || exit 4
done <<!EOF
symas-openssl-$opensslVer.el8.x86_64.rpm
symas-openssl-libs-$opensslVer.el8.x86_64.rpm
symas-heimdal-libs-$heimdalVer.el8.x86_64.rpm
symas-cyrus-sasl-libs-$cyrus_saslVer.el8.x86_64.rpm
symas-libargon2-libs-$libargon2Ver.el8.x86_64.rpm
symas-libevent-libs-$libeventVer.el8.x86_64.rpm
symas-openldap-clients-$openldapVer.el8.x86_64.rpm
symas-openldap-libs-$openldapVer.el8.x86_64.rpm
symas-openldap-servers-$openldapVer.el8.x86_64.rpm
symas-openldap-pw-bcrypt-$pw_bcryptVer.el8.x86_64.rpm
!EOF

echo "Generating the installation tarball ${tarballDir:-~}/$tarballName..."
cd $(dirname $syWork/$syPrefix)
rm -f ${tarballDir:-~}/${tarballName:?tarballName}*
tar cf ${tarballDir:-~}/$tarballName $(basename $syPrefix) || exit 5
xz ${tarballDir:-~}/$tarballName

echo "Done. The tarball should be unpacked relative to $(dirname $syPrefix)"

rm -rf $syWork
