#!/bin/bash
# Copyright (c) 2022 Symas Corporation
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# * Redistributions of source code must retain the above copyright
# notice, this list of conditions and the following disclaimer.
# * Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in
# the documentation and/or other materials provided with the
# distribution.
# * Neither the name of the Symas Corporation nor the names of its
# contributors may be used to endorse or promote products derived
# from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# common.sh
# -----
#
# Source the needed files. This bit of code runs when this file is loaded
for i in ./bvars.vars; do
	if [ -f $i ]; then
		. $i || echo "ERROR: Envrionment variable file $i has errors" || \
		  exit 100
	else
		echo "File $i not found, exiting."
		exit 101
	fi
done

# Common functions for build and packaging scripts
#
# checkenv - Check the environment for correctness. 
#
#
checkenv()
{
	# Check that needed variables are set
	if [ -z "$syWork" -o -z "$syPrefixRoot" -o -z "$varFix" ]; then
		echo "syWork value is $syWork"
		echo "syPrefixRoot value is $syPrefixRoot"
		echo "varFix value is $varFix"
		echo "None of these can be empty. Exiting."
		exit 102
	fi

	# Test for needed directories and accesses
	if [ ! -d $syPrefixRoot ]; then
		echo "Directory $syPrefixRoot must exist befor runnning this script."
		exit 103
	fi

	if [ ! -r $syPrefixRoot ]; then
		echo "Directory $syPrefixRoot must be readable by user $USER."
		exit 104
	fi

	if [ ! -x $syPrefixRoot ]; then
		echo "Directory $syPrefixRoot must be searchable by user $USER."
		exit 105
	fi
}

#
# deleteInstalledServer - Uninstall the Symas OpenLDAP server
#
deleteInstalledServer()
{
	rm -rf $syPrefix/{bin,sbin,etc,lib,share,ssl,include}
}
